<?php
/****************************************
 * XKLog 输出控制函数库
 *
 * 此文件定义所有 show_ 函数
 *
 * 更新：2009-5-23
 * 版本：V1.0
 ****************************************/

!defined('IN_XKLOG') && exit('Access Denied!');

function show_err( $message ){
	obclean();
	@header("content-Type: text/html; charset=utf-8");
	echo '<html><head><title>XKLog 运行时错误</title><meta http-equiv = "Content-Type" content = "text/html; charset=UTF-8" /><style type="text/css">p,body{font-family:tahoma,arial,sans-serif;font-size:11px;}a { text-decoration: none;}a:hover{ text-decoration: underline;}td { border-right: 1px; border-top: 0px; font-size: 16px; color: #000000;}</style></head>';
	echo "<body><table style='TABLE-LAYOUT:fixed;WORD-WRAP: break-word'><tr><td>$message";
	echo '<br /><br />出错地址: http://' . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'] . '?' . $_SERVER['QUERY_STRING'];;
	echo '<br /><br />您可以前往 <a target=_blank href="http://www.xklab.cn/"><b>官方网站</b></a> 获取帮助';
	echo '</td></tr></table></body></html>';
	exit;
}

// 提示信息
function show_message( $msg, $url = '', $litime = 3000 ){
	global $_ENV;
	if( is_array($msg) ){
		$temp = '<ol>';
		foreach($msg as $row => $value){
			$temp .= '<li>' . $value . '</li>';
		}
		$temp .= '</ol>';
		$msg = $temp;
		unset($temp);
	}
	if( $url == '' ){
		$_ENV['message'] = array(
			'content' => $msg,
			'goto'     => '',
		);
	}else{
		$_ENV['message'] = array(
			'content' => $msg . "<script>setTimeout(\"window.location.href='" . $url . "';\",{$litime});</script>",
			'goto'     => '<a href="' . $url . '">如果您的浏览器没自动跳转，请点击这里</a>',
		);
	}
	template('message');
}

function show_admin_message( $msg, $url = '', $litime = 3000 ) {
	global $_ENV,$_CACHE;
	if( is_array($msg) ){
		$temp = '<ol>';
		foreach($msg as $row => $value){
			$temp .= '<li>' . $value . '</li>';
		}
		$temp .= '</ol>';
		$msg = $temp;
		unset($temp);
	}
	if( $url == '' ){
		$_ENV['message'] = array(
			'content' => $msg,
			'goto'     => '',
		);
	}else{
		$_ENV['message'] = array(
			'content' => $msg . "<script>setTimeout(\"window.location.href='" . $url . "';\",{$litime});</script>",
			'goto'     => '<a href="' . $url . '">如果您的浏览器没自动跳转，请点击这里</a>',
		);
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns = "http://www.w3.org/1999/xhtml" lang = "zh-cn">
<head>
<meta http-equiv = "Content-Type" content = "text/html; charset=UTF-8">
<title><?php echo $_CACHE['set'][0]['BlogName'] ?> - 提示信息 </title>
<style type="text/css">
	body{color: #333;font:9pt/200% Verdana;}
	a{text-decoration: none;color:#333333}
	a:hover{text-decoration: underline;}
</style>
</head>
<body>
<center>
	<div style="padding:15px 60px; border:1px solid #c7e1ef; background:#dff6ff; text-align:center; margin:20% auto auto; width:55%">
		<a href="<?php show_blog_path() ?>"><?php echo $_CACHE['set'][0]['BlogName'] ?></a></a> &raquo; 提示信息<br />[<span style = "color:red;"> <?php echo $_ENV['message']['content'] ?> </span>]<br />
		<?php echo $_ENV['message']['goto'] ?>
		<!--<br /><?php show_run_info()?>-->
	</div>
</center>
</body>
</html>
<?php
}

//页面标题
function show_title() {
	global $_CACHE,$_ENV;
	if (isset($_ENV['title'])) {
		echo $_ENV['title'] . ' - '.$_CACHE['set'][0]['BlogName'];
	} else {
		echo $_CACHE['set'][0]['BlogName'] . ' - ' . $_CACHE['set'][0]['Description'];
	}
}

//keyword标签
function get_keywords() {
	global $_CACHE,$_ENV;
	if( isset( $_ENV['keywords'] ) && $_ENV['keywords'] != '' ) {
		echo $_ENV['keywords'];
	}else{
		echo $_CACHE['set'][0]['KeyWords'];
	}
}

//description标签
function get_description() {
	global $_CACHE,$_ENV;
	if( isset( $_ENV['description'] ) && $_ENV['description'] != '' ) {
		echo $_ENV['description'];
	}else{
		echo $_CACHE['set'][0]['Description'];
	}
}

//js
function show_js_head() {
	global $_CACHE;
	$output = "<script language=\"javascript\" type=\"text/javascript\" src=\"" . BLOG_PATH . "script/common.js\"></script>";
	$output .= "<script language=\"javascript\" type=\"text/javascript\">var blog_url = '" . $_CACHE['set'][0]['Domain'] . "';var BLOG_PATH= '" . BLOG_PATH . "' ;var image_resize_width = 500;</script>";
	echo $output;
}

function show_js_foot() {

}

// 博客信息
function show_blog_info($ikey) {
	global $_CACHE;
	$value = '';
	if (array_key_exists($ikey, $_CACHE['set'][0])) {
		$value = $_CACHE['set'][0][$ikey];
	}
	echo $value;
}

// 安装路径
function show_blog_path() {
	echo BLOG_PATH;
}

// 博客版本
function show_version() {
	echo XKLOG_VERSION;
}

// 菜单项目
function show_menu() {
	global $_CACHE,$_ENV;
	$value = '';
	if( !isset( $_ENV['title'] ) ) $_ENV['title'] = '';
	foreach( $_CACHE['menu'] as $ikey => $ivalue ) {
		if( $ivalue['Type'] == 0 ){
			if( $_ENV['title'] == $ivalue['Title'] ){
				$value .= '<li class="current_page"><a href="' . BLOG_PATH . $ivalue['Address'] . '">' . $ivalue['Title'] . '</a></li>';
			}else{
				$value .= '<li><a href="' . BLOG_PATH . $ivalue['Address'] . '">' . $ivalue['Title'] . '</a></li>';
			}
		}else{
			if( $_ENV['title'] == $ivalue['Title'] ){
				$value .= '<li class="current_page"><a href="' . BLOG_PATH . $ivalue['Address'] . '" target="_blank">' . $ivalue['Title'] . '</a></li>';
			}else{
				$value .= '<li><a href="' . BLOG_PATH . $ivalue['Address'] . '" target="_blank">' . $ivalue['Title'] . '</a></li>';
			}
		}
	}
	if( user_is_admin() && !isset( $_ENV['page_make'] ) ){
		if( $_ENV['title'] == '管理' ){
			$value .= '<li class="current_page"><a href="' . BLOG_PATH . 'admin.php">管理</a></li>';
		}else{
			$value .= '<li><a href="' . BLOG_PATH . 'admin.php">管理</a></li>';
		}
	}
	echo $value;
}

//运行信息
function show_run_info() {
	global $db,$start_time;
	$mtime = explode(' ',microtime());
	$stop_time = $mtime[0] + $mtime[1];
	$run_time = number_format($stop_time - $start_time, 6);
	if ( /*get_config('blog','obstart') &&*/ function_exists('ob_gzhandler') ) { $temp = 'Gzip enabled'; }else{ $temp = ''; }
	echo 'Processed in ' . $run_time . ' second(s), ' . $db->querynum . ' queries, ' . $temp;
}

// 日志分类
function show_category( $showrss = false, $str_len = 30, $a_tag = '<li>', $b_tag = '</li>' ) {
	global $_CACHE;
	$output = '';
	foreach ( $_CACHE['category'] as $row ) {
		$rssicon = ' [<a href="' . BLOG_PATH . 'rss.php?cate=' . $row['CID'] . '">RSS</a>]';
		$output .= $a_tag . '<a href="' . BLOG_PATH . 'index.php?cate=' . $row['CID'] . '" title="' . $row['Name'] . '">' . cut_str( $row['Name'],$str_len ) . '(' . $row['ArticleNum'] . ')</a>' . $rssicon . $b_tag;
	}
	echo $output;
}

// 最新评论
function show_comment_new( $str_len = 30, $a_tag = '<li>', $b_tag = '</li>' ) {
	global $_CACHE;
	$output = '';
	foreach ($_CACHE['comment_new'] as $row) {
		if( $row['Address'] == '' ) $row['Address'] = $row['ArticleID'];
		if( $row['Type'] == '动态' ){
			$output .= $a_tag . '<a href="' . BLOG_PATH . 'read.php?id=' . $row['ArticleID'] . '" title="[' . $row['Author'] . '] 发表在 [' . cut_str( strip_tags( $row['Title'] ),$str_len ) . ']">' . $row['Comment'] . '</a>' . $b_tag;
		}elseif ( $row['Type'] == '静态' ) {
			$output .= $a_tag . '<a href="' . BLOG_PATH . 'article/' . $_CACHE['category'][$row['Category']]['Alias'] . '/' . $row['Address'] . '.html" title="[' . $row['Author'] . '] 发表在 [' . cut_str( strip_tags( $row['Title'] ),$str_len ) . ']">' . $row['Comment'] . '</a>' . $b_tag;
		}else{
			$output .= $a_tag . '<a href="' . BLOG_PATH . 'article/' . $_CACHE['category'][$row['Category']]['Alias'] . '/' . $row['Address'] . '.php" title="[' . $row['Author'] . '] 发表在 [' . cut_str( strip_tags( $row['Title'] ),$str_len ) . ']">' . $row['Comment'] . '</a>' . $b_tag;
		}
	}
	echo $output;
}

// 最新留言
function show_guestbook_new( $str_len = 30, $a_tag = '<li>', $b_tag = '</li>' ) {
	global $_CACHE;
	$output = '';
	foreach ($_CACHE['guestbook_new'] as $row) {
		$output .= $a_tag . '<a href="' . BLOG_PATH . 'guestbook.php" title="[' . $row['Author'] . '] 发表">' . str_replace( '<br />', ' ', $row['Comment'] ) . '</a>' . $b_tag;
	}
	echo $output;
}

// 最新、随机、热门文章
function show_article_li( $type = 'new', $str_len = 30, $a_tag = '<li>', $b_tag = '</li>') {
	global $_CACHE,$db;
	$output = '';
	if( $type == 'new' ){
		$temp = $_CACHE['article_new'];
	}elseif( $type == 'hot' ){
		$temp = $_CACHE['article_hot'];
	}else{
		// 读取随机文章
		$sql = 'select ID,Title,Type,Address,Category from `' . PREFIX_STR . 'Article` where IsDel=False order by rand() limit 0,6';
		$query = $db->query($sql);
		while ( $row = $db->fetch_array($query) ) {
			$temp[] = $row;
		}
	}
	foreach ( $temp as $row) {
		if( $row['Address'] == '' ) $row['Address'] = $row['ID'];
		if( $row['Type'] == '动态' ){
			$output .= $a_tag . '<a href="' . BLOG_PATH . 'read.php?id=' . $row['ID'] . '" title="' . strip_tags( $row['Title'] ) . '">'.cut_str( $row['Title'],$str_len ).'</a>' . $b_tag;
		}elseif( $row['Type'] == '静态' ) {
			$output .= $a_tag . '<a href="' . BLOG_PATH . 'article/' . $_CACHE['category'][$row['Category']]['Alias'] . '/' . $row['Address'] . '.html" title="' . strip_tags( $row['Title'] ) . '">'.cut_str( $row['Title'],$str_len ).'</a>' . $b_tag;
		}else{
			$output .= $a_tag . '<a href="' . BLOG_PATH . 'article/' . $_CACHE['category'][$row['Category']]['Alias'] . '/' . $row['Address'] . '.php" title="' . strip_tags( $row['Title'] ) . '">'.cut_str( $row['Title'],$str_len ).'</a>' . $b_tag;
		}
	}
	echo $output;
}

// 友情链接
function show_link( $str_len = 30, $a_tag = '<li>', $b_tag = '</li>' ) {
	global $_CACHE;
	$output = '';
	foreach ($_CACHE['link'] as $row) {
		$output .= $a_tag . '<a href="' . $row['Address'] . '" title="' . $row['Description'] . '" target="_blank">' . cut_str( $row['Title'],$str_len ) . '</a>' . $b_tag;
	}
	echo $output;
}

// 统计信息
function show_count( $a_tag = '<li>', $b_tag = '</li>' ) {
	global $_CACHE;
	$output = $a_tag . '建站时间：' . date('Y年m月d日', $_CACHE['set'][0]['BuildDate']) . $b_tag;
	$output .= $a_tag . '日志：' . $_CACHE['count'][0]['article_num'] . '篇' . $b_tag;
	$output .= $a_tag . '评论：' . $_CACHE['count'][0]['comment_num'] . '篇' . $b_tag;
	$output .= $a_tag . '留言：' . $_CACHE['count'][0]['guestbook_num'] . '篇' . $b_tag;
	$output .= $a_tag . '用户：' . $_CACHE['count'][0]['user_num'] . '人' . $b_tag;
	$output .= $a_tag . '访问：' . $_CACHE['set'][0]['VisitNum'] . '次' . $b_tag;
	$output .= $a_tag . '在线：' . $_CACHE['count'][0]['Online'] . '人' . $b_tag;
	echo $output;
}

// 首页日志列表
function show_article( $cate_id ){
	global $_ENV,$_CACHE,$db,$max_per_page,$offset,$current_page;
	if ( array_key_exists( $cate_id , $_CACHE['category'] ) ) {
		$sql = "SELECT * FROM `" . PREFIX_STR . "Article` WHERE IsDel = 0 AND Category = " . $cate_id . " ORDER BY IsTop DESC,ID DESC LIMIT $offset, $max_per_page";
		$article_num = $_CACHE['category'][$cate_id]['ArticleNum'];
	}else{
		$sql = "SELECT * FROM `" . PREFIX_STR . "Article` WHERE IsDel = 0 ORDER BY IsTop DESC,ID DESC LIMIT $offset, $max_per_page";
		$article_num = $_CACHE['count'][0]['article_num'];
	}
	$temp = array();
	$temp = $db->fetch_all( $sql );
	foreach( $temp as $row => $value ){
		$_ENV['article'] = $value;
		show_article_de( &$_ENV['article'] );
	}
	show_navigator( $current_page,$article_num,$cate_id,'index.php');
}

// 日志详细
function show_article_detail( $id ){
	global $db;
	$sql = "SELECT * FROM `" . PREFIX_STR . "Article` WHERE IsDel = 0 AND ID=$id";
	$_ENV['article'] = $db->fetch_one_array( $sql );
	show_article_de( &$_ENV['article'],'all' );
}
// 日志详细
function show_article_de( $value ,$type = 'sum' ){
	global $_ENV,$_CACHE;
	if( $type == 'sum' && $value['Summary'] != '' ){
		$value['Content'] = $value['Summary'];
	}
	unset( $value['Summary'] );
	if( $value['IsTop'] ){
		$value['Title'] = '[置顶] ' . $value['Title'];
	}
	if( $value['Address'] == '' ) $value['Address'] = $value['ID'];
	if( $value['Type'] == '动态' ){
		$value['URL'] = BLOG_PATH . 'read.php?id=' . $value['ID'];
	}elseif( $value['Type'] == '半静态' ) {
		$value['URL'] = BLOG_PATH . 'article/' . $_CACHE['category'][$value['Category']]['Alias'] . '/' . $value['Address'] . '.php';
	}else{
		$value['URL'] = BLOG_PATH . 'article/' . $_CACHE['category'][$value['Category']]['Alias'] . '/' . $value['Address'] . '.html';
	}
	if( $value['Tag'] != '' ){
		$temp = array();
		$value['Tag'] = str_replace( '*}{*',',',$value['Tag']);
		$value['Tag'] = str_replace( '{*','',$value['Tag']);
		$value['Tag'] = str_replace( '*}','',$value['Tag']);
		$temp = split( ',' , $value['Tag']);
		$value['Tag'] = '';
		foreach($temp as $row){
			$value['Tag'] .= '<a href="' . BLOG_PATH . 'search.php?type=tag&word=' . $row . '">' . $_CACHE['tag'][$row]['T_Name'] . '</a>';
		}
		$value['Tag'] = str_replace( '</a><a href=','</a> , <a href=',$value['Tag'] );
	}
	$value['Category'] = '<a href="' . BLOG_PATH . 'index.php?cate=' . $value['Category'] . '" title="' . $_CACHE['category'][$value['Category']]['Description'] . '">' . $_CACHE['category'][$value['Category']]['Name'] . '</a>';
	// 管理选项
	if( user_is_admin() && !isset( $_ENV['page_make'] ) ) {
		$value['Admin'] = '<div class="post_admin">';
		if( $value['IsTop'] ){
			$value['Admin'] .= '管理：<a href = "' . BLOG_PATH . 'admin.php?do=topcancel&id=' . $value['ID'] . '">[取消置顶]</a>';
		}else{
			$value['Admin'] .= '管理：<a href = "' . BLOG_PATH . 'admin.php?do=top&id=' . $value['ID'] . '">[置顶]</a>';
		}
		if( $value['Type'] == '静态' ){
			if( $value['Update'] == 1 ){
				$value['Admin'] .= " <a href = '" . BLOG_PATH . "admin.php?do=reflash&id=" . $value['ID'] . "'><font color=red>[刷新]</font></a>";
			}else{
				$value['Admin'] .= " <a href = '" . BLOG_PATH . "admin.php?do=reflash&id=" . $value['ID'] . "'>[刷新]</a>";
			}
			$value['Admin'] .= ' <a href = "' . BLOG_PATH . 'read.php?id=' . $value['ID'] . '">[动态页地址]</a>';
		}
		$value['Admin'] .= '<a href = "' . BLOG_PATH . 'admin.php?do=edit&id=' . $value['ID'] . '">[修改]</a>';
		$value['Admin'] .= "<a href='javascript:if(confirm(\"确实要删除吗?\"))location=\"" . BLOG_PATH . "admin.php?do=del&id=" . $value['ID'] . "\"'>[删除]</a></div>";
	}else{
		$value['Admin'] = '';
	}
	template('article');
}

// 分页
function show_navigator($current_page, $article_num, $cate_name, $page_name){
	global $max_per_page;
	if( $article_num < $max_per_page + 1 ) return;
	$page_name = BLOG_PATH . $page_name;
	if( ( $article_num % $max_per_page ) == 0 ){
		$page_num = floor( $article_num / $max_per_page );
	}else{
		$page_num = floor( $article_num / $max_per_page ) + 1;
	}

	if( $cate_name != 0 ){
		$cate_name = 'cate=' . $cate_name . "&";
	}else{
		$cate_name = '';
	}

	$leader = '<div class = "navigator"><span class = "navigator_tip">分页：' . $current_page . '/' . $page_num . '</span>';
	$leader .= '<a href = "' . $page_name . '?' . $cate_name . 'page=1">«</a>';
	if( $current_page == 1 ){
		$i = 1;
	}else{
		$i = $current_page - 1;
	}
	$leader .= '<a href = "' . $page_name . '?' . $cate_name . 'page=' . $i . '">‹</a>';

	if( $current_page > 5 ){
		$leader .= ' …… ';
		for( $i = $current_page - 4 ; $i < $current_page ; $i ++ ){
			$leader .= '<a href="' . $page_name . '?' . $cate_name . 'page=' . $i . '">' . $i . '</a>';
		}
	}else{
		for($i = 1 ; $i < $current_page ; $i ++ ){
			$leader .= '<a href="' . $page_name . '?' . $cate_name . 'page=' . $i . '">' . $i . '</a>';
		}
	}

	$leader .= '<span class="navigator_current">' . $current_page . '</span>';

	if( $page_num - $current_page > 4 ){
		for($i = $current_page + 1 ; $i < $current_page + 5 ; $i ++ ){
			$leader .= '<a href="' . $page_name . '?' . $cate_name . 'page=' . $i . '">' . $i . '</a>';
		}
		$leader .= ' …… ';
	}else{
		for( $i = $current_page + 1 ; $i < $page_num + 1 ; $i ++ ){
			$leader .= '<a href="' . $page_name . '?' . $cate_name . 'page=' . $i . '">' . $i . '</a>';
		}
	}

	if( $current_page > $page_num - 1 ){
		$i = $page_num;
	}else{
		$i = $current_page + 1;
	}
	$leader .= '<a href = "' . $page_name . '?' . $cate_name . 'page=' . $i . '">›</a>';
	$leader .= '<a href = "' . $page_name . '?' . $cate_name . 'page=' . $page_num . '">»</a></div>';

	echo $leader;
}

// 输出评论
function show_comment($aid){
	global $_CACHE,$db;
	if( $_CACHE['set'][0]['ComNum'] < 1 ){
		$sql = 'select * from `' . PREFIX_STR . 'Comment` where ArticleID=' . $aid . ' and IsDel=False order by CID desc';
	} else {
		$sql = 'select * from `' . PREFIX_STR . 'Comment` where ArticleID=' . $aid . ' and IsDel=False order by CID desc LIMIT ' . $_CACHE['set'][0]['ComNum'];
	}
	$temp = array();
	$temp = $db->fetch_all( $sql );
	if( $temp == array() ){
		echo '<div class="messagebox">暂无评论。</div>';
		return;
	}
	foreach( $temp as $row => $value ){
		$_ENV['comment'] = $value;
		show_comment_de();
	}
}

// 评论详细
function show_comment_de(){
	global $_ENV;
	If( $_ENV['comment']['Email'] <> '' ){
		$gravatar = split( "\|" , $_ENV['comment']['Email'] );
		$_ENV['comment']['Gravatar'] = '<img src="http://www.gravatar.com/avatar.php?gravatar_id=' . $gravatar[1] . '?s=32&amp;d=wavatar&amp;r=G" height="32" width="32" alt="Gravatar" class="Gravatar" />';
	}else{
		$_ENV['comment']['Gravatar'] = '<img src="' . BLOG_PATH . 'images/gravatar.jpg" height="32" width="32" alt="Gravatar" class="Gravatar" />';
	}
	// 管理选项
	if( user_is_admin() && !isset( $_ENV['page_make'] ) ) {
		$_ENV['comment']['Admin'] = '<div class="comment_admin"><div class = "comment_admin_editor" id = "' . $_ENV['comment']['CID'] . '" style = "display:none"><form action="' . BLOG_PATH . 'admin.php?do=addreply&id=' . $_ENV['comment']['CID'] . '" method = "post"><textarea name = "CommentReply" rows="4" cols="50"></textarea><br /><input type = "submit" name = "Submit" class="button" value = "回复" /></form></div>';
		$_ENV['comment']['Admin'] .= "<div class = \"comment_admin_content\">管理：<a href = \"javascript:ShowHideDiv(" . $_ENV['comment']['CID'] . ")\">[回复]</a> <a href=\"javascript:if(confirm('确实要删除吗?'))location='" . BLOG_PATH . "admin.php?do=delcomment&id=" . $_ENV['comment']['CID'] . "'\">[删除]</a></div></div>";
	}else{
		$_ENV['comment']['Admin'] = '';
	}
	// 显示控制
	if( $_ENV['comment']['IsShow'] == 0 ) {
		if( user_is_admin() && !isset( $_ENV['page_make'] ) ) {
			$_ENV['comment']['Comment'] .= '<br /><font color="red">[此评论需要管理员审核后才能显示]</font>';
			$_ENV['comment']['Admin'] = '<div class="comment_admin"><div class = "comment_admin_editor" id = "' . $_ENV['comment']['CID'] . '" style = "display:none"><form action="' . BLOG_PATH . 'admin.php?do=addreply&id=' . $_ENV['comment']['CID'] . '" method = "post"><textarea name = "CommentReply" rows="4" cols="50"></textarea><br /><input type = "submit" name = "Submit" class="button" value = "回复" /></form></div>';
			$_ENV['comment']['Admin'] .= "<div class = \"comment_admin_content\">管理：<a href = \"" . BLOG_PATH . "admin.php?do=censor&id=" . $_ENV['comment']['CID'] . "\">[审核通过]</a> <a href = \"javascript:ShowHideDiv(" . $_ENV['comment']['CID'] . ")\">[回复]</a> <a href=\"javascript:if(confirm('确实要删除吗?'))location='" . BLOG_PATH . "admin.php?do=delcomment&id=" . $_ENV['comment']['CID'] . "'\">[删除]</a></div></div>";
		}else{
			$_ENV['comment']['Comment'] = '[此评论需要管理员审核后才能显示]';
		}
	}
	if( $_ENV['comment']['IsShow'] == 2 ) {
		if( user_is_admin() && !isset( $_ENV['page_make'] ) ) {
			$_ENV['comment']['Comment'] .= '<br />[这是一句悄悄话，仅管理员可见]';
		}else{
			$_ENV['comment']['Comment'] = '[这是一句悄悄话，仅管理员可见]';
		}
	}
	template('comment');
}
function show_comment_de_reply(){
	global $_ENV;
	$_ENV['comment']['Author'] = $_ENV['comment']['ReplyUser'];
	$_ENV['comment']['Comment'] = $_ENV['comment']['Reply'];
	$_ENV['comment']['Time'] = $_ENV['comment']['ReplyTime'];
	$_ENV['comment']['Gravatar'] = '<img src="' . BLOG_PATH . 'images/gravatar.jpg" height="32" width="32" alt="Gravatar" class="Gravatar" />';
	$_ENV['comment']['Index'] = '';
	$_ENV['comment']['Admin'] = "<div class=\"comment_admin\"><div class = \"comment_admin_content\">管理：<a href=\"javascript:if(confirm('确实要删除吗?'))location='" . BLOG_PATH . "admin.php?do=delreply&id=" . $_ENV['comment']['CID'] . "'\">[删除]</a></div></div>";
	$_ENV['comment']['ReplyUser'] = NULL;
	template('comment');
}

// 留言
function show_guestbook(){
	global $_ENV,$_CACHE,$db,$max_per_page,$offset,$current_page;
	$sql = "SELECT * FROM `" . PREFIX_STR . "Comment` WHERE IsDel=False AND ArticleID = 0 ORDER BY CID DESC LIMIT $offset, $max_per_page";
	$temp = array();
	$temp = $db->fetch_all( $sql );
	foreach( $temp as $row => $value ){
		$_ENV['comment'] = $value;
		show_comment_de();
	}
	show_navigator( $current_page,$_CACHE['count'][0]['guestbook_num'],0,'guestbook.php');
}

// 标签云
function show_tags(){
	global $_CACHE;
	foreach( $_CACHE['tag'] as $tag){
		echo '<a href="search.php?tag=' . $tag['T_ID'] . '" title="共包含 ' . $tag['T_Num'] . ' 篇日志"><span style="font-size:' . get_tag_size( $tag['T_Num'] ) . 'px">' . $tag['T_Name'] . ' [' . $tag['T_Num'] . ']</span></a>&nbsp;&nbsp;&nbsp;';
	}
}

function get_tag_size( $num ){
    for( $i = 1; $i < 11; $i ++ ){
        if( $num < ( $i * 2.5 ) ) {
            return 12 + $i;
		}
	}
    return 22;
}

function get_user_info($key) {
	global $_CACHE;
	if (isset($_CACHE['user'][$key])) {
		return $_CACHE['user'][$key];
	}
}

function get_set_info($key) {
	global $_CACHE;
	if (isset($_CACHE['set'][0][$key])) {
		return $_CACHE['set'][0][$key];
	}
}

//-----------------------------------------------------------------------------------------



// 评论是否需要验证码
function comment_need_vdcode() {
	return false;
}
?>